
		ORG		&a200
		write "SPRCODE.BIN"



		LD		HL,BufferRsx
		LD		BC,PtrRsx
		JP		#BCD1

PtrRsx:
		DW		RSX_TABLE
		JP		set_shape
		JP		set_tile
		JP		set_size


RSX_TABLE:
		DB		"DRA","W"+#80
		DB		"DRAWTIL","E"+#80
		DB		"SIZ","E"+#80
		DB		0

BufferRsx:
		DS		4
set_size
		ld a,(ix+2)
		ld (WIDTH+1),a
		ld a,(ix+0)
		ld (HEIGHT+1),a
		ret
		
set_shape
		ld		IY,xormode
		CP		&04
		jr		z,doxor
		CP		&03
		RET		NZ
		ld		A,0
		jp		noxor

doxor:
		ld		A,&AE
noxor:
		ld		(IY+0),A

		ld		IY,tempbuf
		ld		H,(IX+1)
		ld		L,(IX+0) ;; buffer (source)
		ld		A,(IX+4)
		add		(HL)
		ld		(IY),A  ;; (IY) = X position + breite
		inc		HL
		ld		A,(IX+2)
		add		(HL)
		ld		(IY+1),A ;; (IY+1) = Y position + hoehe
		inc		HL
		ld		D,H
		ld		E,L  ;; DE = buffer (source)
		ld		B,(IX+2) ;; Y
set_loop0
		ld		C,(IX+4) ;; X
		call		calc_adr ;; HL = screen memory
set_loop1
		ld		A,(DE)
xormode
		nop
		ld		(HL),A
		inc		HL
		inc		DE
		inc		C
		ld		A,(IY+0) ;; Breite
		cp		C
		jr		nz,set_loop1
		inc		B
		ld		A,(IY+1) ;; Hoehe
		cp		B
		jr		nz,set_loop0
		RET


set_tile
		ld		IY,xormode2
		CP		&04
		jr		z,doxor2
		CP		&03
		RET		NZ
		ld		A,0
		jp		noxor2

doxor2:
		ld		A,&AE
noxor2:
		ld		(IY+0),A

		ld		IY,tempbuf
		ld		H,(IX+1)
		ld		L,(IX+0) ;; buffer (source)
		ld		A,(IX+4)
		;add		(HL)
		width:
		add		123
		ld		(IY),A  ;; (IY) = X position + breite
		;inc		HL
		ld		A,(IX+2)
		;add		(HL)
		height:
		add		123
		ld		(IY+1),A ;; (IY+1) = Y position + hoehe
		;inc		HL
		ld		D,H
		ld		E,L  ;; DE = buffer (source)
		ld		B,(IX+2) ;; Y
set_loop02
		ld		C,(IX+4) ;; X
		call		calc_adr ;; HL = screen memory
set_loop12
		ld		A,(DE)
xormode2
		nop
		ld		(HL),A
		inc		HL
		inc		DE
		inc		C
		ld		A,(IY+0) ;; Breite
		cp		C
		jr		nz,set_loop12
		inc		B
		ld		A,(IY+1) ;; Hoehe
		cp		B
		jr		nz,set_loop02
		RET

		;;		--------------------------------------------------------------------------------

calc_adr		;; in : C -> X (0..79)
		;;		B -> Y (0..199)
		;;		out: HL -> Screen location
		push		AF
		push		BC
		push		DE
		ld		A,B
		and		&07  ;; A = Y modulo 8
		ld		H,0
		ld		L,A  ;; HL = A
		add		HL,HL  ;; * 2
		add		HL,HL  ;; * 4
		add		HL,HL  ;; * 8
		add		HL,HL  ;; * 16
		add		HL,HL  ;; * 32
		add		HL,HL  ;; * 64
		add		HL,HL  ;; * 128
		add		HL,HL  ;; * 256
		add		HL,HL  ;; * 512
		add		HL,HL  ;; * 1024
		add		HL,HL  ;; HL = (Y modulo 8) * 2048
		push		HL
		srl		B  ;; \ 2
		srl		B  ;; \ 4
		srl		B  ;; \ 8
		ld		L,B
		ld		H,0  ;; HL = Y \ 8
		add		HL,HL  ;; * 2
		add		HL,HL  ;; * 4
		add		HL,HL  ;; * 8
		add		HL,HL  ;; * 16
		ld		D,H
		ld		E,L  ;; DE = HL = Y \ 8 * 16
		add		HL,HL  ;; * 32
		add		HL,HL  ;; HL = Y \ 8 * 64
		add		HL,DE  ;; HL = Y \ 8 * 80
		pop		DE
		add		HL,DE  ;; HL = (Y modulo 8) * 1024 + (Y\8*80)
		ld		B,0
		add		HL,BC  ;; HL = (Y modulo 8) * 1024 + (Y\8*80) + X
		ld		BC,&C000
		add		HL,BC
		pop		DE
		pop		BC
		pop		AF
		ret

tempbuf		ds 4
